

#ifdef MACVERSION
	#include <standard.h>
#endif

#ifdef WIN95VERSION
	#include "standard.h"
#endif

#include "font.h"
#include "quickdraw.h"
#include "memory.h"
#include "strings.h"
#include "textedit.h"



void edittextbox (bigstring bs, Rect r, short fontnum, short fontsize, short fontstyle) {
	
	pushstyle (fontnum, fontsize, fontstyle);
	
	#ifdef MACVERSION
		TETextBox (stringbaseaddress (bs), (long) stringlength (bs), &r, teJustLeft);
	#endif

	#ifdef WIN95VERSION
		setWindowsFont();
	
		DrawText (getcurrentDC(), stringbaseaddress (bs), stringlength (bs), &r, 
				DT_LEFT | DT_END_ELLIPSIS | DT_WORDBREAK);
	
		clearWindowsFont();
	#endif
	
	popstyle ();
	} /*edittextbox*/


boolean edittwostringbox (bigstring bs1, bigstring bs2, Rect r, short fontnum, short fontsize) {
	
	/*
	a front-end for the textedit routine TextBox.  we take two strings, concatenate
	them in a buffer with two carriage returns between the strings, display the
	result, dispose the buffer.
	*/
	
	long len;
	Handle hbuffer;
	bigstring bs;
	
	if (!newtexthandle (bs1, &hbuffer))
		return (false);
	
	if (stringlength (bs2) > 0) {
		
		setstringlength (bs, 2);
		
		bs [1] = bs [2] = chreturn;
		
		if (!pushtexthandle (bs, hbuffer)) {
			
			disposehandle (hbuffer);
			
			return (false);
			}
			
		if (!pushtexthandle (bs2, hbuffer)){
			
			disposehandle (hbuffer);
			
			return (false);
			}
		}
		
	len = gethandlesize (hbuffer);
		
	pushstyle (fontnum, fontsize, 0);
	
	lockhandle (hbuffer);
	
	#ifdef MACVERSION
		TETextBox (*hbuffer, len, &r, teJustLeft);
	#endif

	#ifdef WIN95VERSION
		setWindowsFont();
		
		DrawText (getcurrentDC(), *hbuffer, len, &r, DT_LEFT | DT_END_ELLIPSIS | DT_WORDBREAK);
		
		clearWindowsFont();
	#endif
	
	
	unlockhandle (hbuffer);
	
	disposehandle (hbuffer);
	
	popstyle ();
	
	return (true);
	} /*edittwostringbox*/


